/**
 * \file helper.h
 *
 * \brief Defintiion of helper functions
 *
 * \author Christoph Gellner (cgellner@de.adit-jv.com)
 *
 * \copyright (c) 2016 Advanced Driver Information Technology.
 * This code is developed by Advanced Driver Information Technology.
 * Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
 * All rights reserved.
 *
 *
 ***********************************************************************/
#ifndef __SDC_DAEMON_HELPER_H_
#define __SDC_DAEMON_HELPER_H_

#include <stdbool.h>
#include <sdc.h>

/**
 * Create a directory
 * Optionally including all the parent directories.
 * Optionally it is checked that only root or the current user/group is able
 * to delete the directory (i.e. in case user or group different from root(0)
 * and current uid/gid, sticky required)
 * Please note: In case the folder does already exist these checks are skipped
 * Please note: It is not required do any special handling for trailing "/./"
 * or "//". A folder will only be created if it does not exist.
 * Furthermore the same permissions are used for all newly created folders.
 * Such path segments only leads to checks performed multiple times.
 * So warnings might occur multiple times.
 * '/../' segments might lead to unnecessary directories but won't do any harm.
 *
 * \param abs_path The absolute path of the desired folder
 * \param create_parent Create not existing parent folders
 * \param warn_parent_permissions Print warning if checking permissions fails
 *
 * \return SDC_OK on success or SDC error_code
 */
sdc_error_t sdc_helper_create_absolute_dir(const char *abs_path,
                                           bool create_parent,
                                           bool warn_parent_permissions);

#endif
